/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.nativesystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.PackageConstraint;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

class sExecutionAnalyzer
extends ExecutionAnalyzer {
    @Override
    public boolean verifyMemory(String etoutput, long memReqd, Result result, boolean forSwapCalc) {
        return this.verifyMemory(etoutput, new StorageSize(memReqd, StorageUnit.BYTE), result, forSwapCalc);
    }

    @Override
    public boolean verifyTimeZone(String etoutput, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyTimeZone...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckTimeZone failed");
            result.setStatus(2);
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("1")) {
            result.addTraceInfo("Check TimeZone Consistency failed");
            result.addErrorInfo("Can not find configuration file.");
            result.setStatus(3);
            result.addResultInfo("1");
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("2")) {
            result.addTraceInfo("Check TimeZone Consistency failed");
            result.addErrorInfo("configuration file has no value for TZ.");
            result.setStatus(3);
            result.addResultInfo("2");
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("3")) {
            String tzf = VerificationUtil.getTZFileLoc();
            result.addTraceInfo("Check TimeZone Consistency failed");
            result.addErrorInfo("TZ file in " + tzf + " is corrupted");
            result.setStatus(3);
            result.addResultInfo("3");
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        String cvuTag = "CVU_TZ_INFO";
        if (txtVal != null && txtVal.length() != 0) {
            String tzone = this.filterValueForTimeZone(txtVal, cvuTag);
            result.addResultInfo(tzone);
        } else {
            result.addResultInfo("");
        }
        result.addTraceInfo("Check TimeZone Consistency successful");
        result.setStatus(1);
        return true;
    }

    @Override
    public boolean verifyMemory(String etoutput, StorageSize memReqd, Result result, boolean forSwapCalc) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyMemory...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckMemory failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        String outputLine = null;
        double mem = 0.0;
        double hugePageSize = 0.0;
        double hugePageTotal = 0.0;
        StorageSize memSS = null;
        Object val = null;
        String memInfo = null;
        String memTotalRegEx = "(.*)MemTotal:(\\s*)(\\d*)(\\s*)kB(.*)";
        String hugePageTotalRegEx = "(.*)HugePages_Total:(\\s*)(\\d*)(\\D*)";
        String hugePageSizeRegEx = "(.*)Hugepagesize:(\\s*)(\\d*)(\\s*)kB(.*)";
        Pattern memTotalPattern = null;
        Pattern hughePageTotalPattern = null;
        Pattern hugePageSizePattern = null;
        try {
            memTotalPattern = Pattern.compile(memTotalRegEx);
            hughePageTotalPattern = Pattern.compile(hugePageTotalRegEx);
            hugePageSizePattern = Pattern.compile(hugePageSizeRegEx);
        }
        catch (PatternSyntaxException e) {
            result.addTraceInfo("Could not create patterns to parse the output");
            result.addErrorInfo("verifyMemory failed");
            result.setStatus(2);
            return false;
        }
        StringTokenizer st = new StringTokenizer(txtVal, "\n");
        int tokenCount = st.countTokens();
        if (tokenCount > 1) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\nProcessing memory values from multiple output lines: \n'" + txtVal + "'"));
            }
            while (st.hasMoreTokens()) {
                try {
                    outputLine = st.nextToken();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("Processing line: '" + outputLine + "'"));
                    }
                    outputLine = outputLine.trim();
                    Matcher m1 = memTotalPattern.matcher(outputLine);
                    while (m1.find()) {
                        mem = VerificationUtil.parseStringToNumber(m1.group(3));
                    }
                    Matcher m2 = hughePageTotalPattern.matcher(outputLine);
                    while (m2.find()) {
                        hugePageTotal = VerificationUtil.parseStringToNumber(m2.group(3));
                    }
                    Matcher m3 = hugePageSizePattern.matcher(outputLine);
                    while (m3.find()) {
                        hugePageSize = VerificationUtil.parseStringToNumber(m3.group(3));
                    }
                }
                catch (NoSuchElementException nse) {
                    Trace.out((String)"NOSUCHELEMENTEXCEPTION: while processing available memory");
                }
            }
        } else {
            Matcher m3;
            Matcher m2;
            outputLine = st.nextToken();
            outputLine = outputLine.trim();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\nProcessing all memory values from one output line: \n'" + outputLine + "'"));
            }
            memInfo = outputLine;
            Matcher m1 = memTotalPattern.matcher(outputLine);
            if (m1.matches()) {
                mem = VerificationUtil.parseStringToNumber(m1.group(3));
            }
            if ((m2 = hughePageTotalPattern.matcher(outputLine)).matches()) {
                hugePageTotal = VerificationUtil.parseStringToNumber(m2.group(3));
            }
            if ((m3 = hugePageSizePattern.matcher(outputLine)).matches()) {
                hugePageSize = VerificationUtil.parseStringToNumber(m3.group(3));
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Memory: '" + mem + "' HugePages_Total: '" + hugePageTotal + "' Hugepagesize: '" + hugePageSize + "'"));
        }
        if (forSwapCalc) {
            mem -= hugePageTotal * hugePageSize;
        }
        memSS = new StorageSize(mem, StorageUnit.KBYTE);
        if (mem == 0.0) {
            result.addTraceInfo("Could not parse output from exectask");
            result.addErrorInfo("CheckAvailMemory failed");
            result.setStatus(2);
            return false;
        }
        if (memSS.compareTo(memReqd) >= 0) {
            result.addResultInfo(memSS);
            result.setStatus(1);
            return true;
        }
        result.addTraceInfo("***Memory check failed. Reqd: " + memReqd + ", avail: " + mem);
        result.addErrorInfo("verifyMemory failed");
        result.addResultInfo(memSS);
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyAvailMemory(String etoutput, long memReqd, Result result) {
        return this.verifyAvailMemory(etoutput, new StorageSize(memReqd, StorageUnit.BYTE), result);
    }

    @Override
    public boolean verifyAvailMemory(String etoutput, StorageSize memReqd, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyAvailMemory...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckAvailMemory failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        String outputLine = null;
        double avlMem = 0.0;
        StorageSize avlMemSS = null;
        String val = null;
        String memInfo = null;
        StringTokenizer st = new StringTokenizer(txtVal, "\n");
        int tokenCount = st.countTokens();
        if (tokenCount > 1) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\nProcessing memory values from multiple output lines: \n'" + txtVal + "'"));
            }
            while (st.hasMoreTokens()) {
                try {
                    outputLine = st.nextToken();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("Processing line: '" + outputLine + "'"));
                    }
                    if (Pattern.matches("MemFree: .* kB", outputLine = outputLine.trim()) || Pattern.matches("Buffers: .* kB", outputLine) || Pattern.matches("Cached: .* kB", outputLine)) {
                        int start = txtVal.indexOf(": ") + 2;
                        int end = txtVal.indexOf("kB") - 1;
                        val = txtVal.substring(start, end);
                        val = val.trim();
                        try {
                            if (Trace.isLevelEnabled((int)1)) {
                                Trace.out((String)("Adding: '" + val + "' to avlMem: '" + avlMem + "'"));
                            }
                            avlMem += VerificationUtil.parseStringToNumber(val);
                        }
                        catch (NumberFormatException e) {
                            Trace.out((String)("NUMBERFORMATEXCEPTION: cannot parse '" + val + "' into a long value"));
                        }
                        continue;
                    }
                    Trace.out((String)("Skipping Pattern: '" + outputLine + "'"));
                }
                catch (NoSuchElementException nse) {
                    Trace.out((String)"NOSUCHELEMENTEXCEPTION: while processing available memory");
                }
            }
        } else {
            int end;
            outputLine = st.nextToken();
            outputLine = outputLine.trim();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\nProcessing all memory values from one output line: \n'" + outputLine + "'"));
            }
            memInfo = outputLine;
            while ((end = memInfo.indexOf(" kB")) != -1) {
                if (Pattern.matches("MemFree: .*", memInfo) || Pattern.matches("Buffers: .*", memInfo) || Pattern.matches("Cached: .*", memInfo)) {
                    int start = memInfo.indexOf(":") + 2;
                    val = memInfo.substring(start, end);
                    val = val.trim();
                    memInfo = memInfo.substring(end + 3);
                    try {
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("Adding: '" + val + "' to avlMem: '" + avlMem + "'"));
                        }
                        avlMem += VerificationUtil.parseStringToNumber(val);
                    }
                    catch (NumberFormatException e) {
                        Trace.out((String)("NUMBERFORMATEXCEPTION: cannot parse '" + val + "' into a long value"));
                    }
                    continue;
                }
                memInfo = memInfo.substring(end + 3);
            }
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Available Memory: '" + avlMem + "'"));
        }
        avlMemSS = new StorageSize(avlMem, StorageUnit.KBYTE);
        if (avlMem == 0.0) {
            result.addTraceInfo("Could not parse output from exectask");
            result.addErrorInfo("CheckAvailMemory failed");
            result.setStatus(2);
            return false;
        }
        if (avlMemSS.compareTo(memReqd) >= 0) {
            result.addResultInfo(avlMemSS);
            result.setStatus(1);
            return true;
        }
        result.addTraceInfo("*** Available Memory check failed. Reqd: " + memReqd + ", avail: " + avlMem);
        result.addErrorInfo("CheckAvailMemory failed");
        result.addResultInfo(avlMemSS);
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyProcessAlive(String etoutput, String procName, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyProcessAlive...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckProcessAlive failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        if ((txtVal = txtVal.trim()).length() == 0 || txtVal.equals(" ")) {
            result.addTraceInfo("*** Process alive check failed. Unexpected pattern");
            result.addErrorInfo("CheckProcessAlive failed");
            result.setStatus(3);
            return false;
        }
        int stopped = txtVal.indexOf("T");
        int dead = txtVal.indexOf("X");
        int defunct = txtVal.indexOf("Z");
        if (stopped == -1 && dead == -1 && defunct == -1) {
            result.addResultInfo(txtVal);
            result.setStatus(1);
            return true;
        }
        result.addTraceInfo("*** Process alive check failed. Status: " + txtVal);
        result.addErrorInfo("CheckProcessAlive failed");
        result.addResultInfo(txtVal);
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyRunlevel(String etoutput, int runLvlReqd, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyRunlevel...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckRunlevel failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        boolean bMatched = Pattern.matches(".*run-level .*", txtVal = txtVal.trim());
        if (bMatched) {
            int start = txtVal.indexOf("run-level ") + 9;
            int end = txtVal.indexOf("run-level ") + 12;
            String val = txtVal.substring(start, end);
            val = val.trim();
            int runLvl = 0;
            try {
                runLvl = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                runLvl = -1;
            }
            if (runLvlReqd < 0 || runLvl == runLvlReqd) {
                result.addResultInfo(val);
                result.setStatus(1);
                return true;
            }
            result.addTraceInfo("*** Run level check failed. Reqd: " + Integer.toString(runLvlReqd) + ", found: " + val);
            result.addErrorInfo("CheckRunlevel failed");
            result.addResultInfo(val);
            result.setStatus(3);
            return false;
        }
        result.addTraceInfo("*** Run level check failed. Unexpected pattern");
        result.addErrorInfo("CheckRunlevel failed");
        result.setStatus(2);
        return false;
    }

    @Override
    public boolean verifyDaemonConfigured(String daemonName, String etoutput, String currentRunLevel, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyDaemonConfigured...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Check Daemon Configured failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        if ((txtVal = txtVal.trim()).contains(daemonName)) {
            txtVal = txtVal.substring(txtVal.indexOf(daemonName) + daemonName.length());
        }
        Trace.out((String)("Processing the filtered output String : " + txtVal));
        String[] runlevelStatusArray = txtVal.split("\\s+");
        boolean isDaemonConfigured = false;
        boolean isDaemonConfiguredForReqLevel = false;
        if (runlevelStatusArray != null && runlevelStatusArray.length > 0) {
            String runLvl = null;
            boolean isConfigured = false;
            for (String runlevelStatus : runlevelStatusArray) {
                String[] levelStatus = runlevelStatus.split(":");
                if (levelStatus != null && levelStatus.length > 1) {
                    runLvl = levelStatus[0];
                    Trace.out((String)("The level is " + runLvl + " and the status is " + levelStatus[1]));
                    boolean bl = isConfigured = levelStatus[1].trim().equalsIgnoreCase("on");
                }
                if (!isConfigured) continue;
                Trace.out((String)("Daemon (" + daemonName + ") is configured for run level (" + runLvl + " )"));
                isDaemonConfigured = true;
                if (!VerificationUtil.isStringGood(currentRunLevel) || !VerificationUtil.isStringGood(runLvl) || !currentRunLevel.equalsIgnoreCase(runLvl.trim())) continue;
                isDaemonConfiguredForReqLevel = true;
                break;
            }
            if (isDaemonConfigured) {
                if (isDaemonConfiguredForReqLevel) {
                    result.setStatus(1);
                    return true;
                }
                result.setStatus(4);
                return true;
            }
            result.addTraceInfo("*** Daemon not found configured");
            result.setStatus(3);
            return false;
        }
        result.addTraceInfo("*** Daemon configured check failed. Unexpected pattern");
        result.addErrorInfo("Check Daemon Configured failed");
        result.setStatus(2);
        return false;
    }

    @Override
    public boolean verifyArchitecture(String etoutput, List<String> archValList, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyArchitecture...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckArchitecture failed");
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationResult(etoutput).equals("0")) {
            result.addTraceInfo("Architecture retrieval failed");
            result.addErrorInfo("Check for Architecture failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        boolean bMatched = false;
        if (archValList == null || archValList.size() == 0) {
            bMatched = true;
        } else {
            for (String archVal : archValList) {
                if (bMatched) break;
                if (archVal.equalsIgnoreCase("x86")) {
                    bMatched |= txtVal.endsWith("86");
                    continue;
                }
                String archEx = archVal + ".*";
                bMatched |= Pattern.matches(archEx, txtVal);
            }
        }
        if (bMatched) {
            result.addTraceInfo("Pattern matched with: " + txtVal);
            result.addTraceInfo("System architecture passed");
            result.addResultInfo(txtVal);
            result.setStatus(1);
            return true;
        }
        if (txtVal != null && txtVal.length() != 0) {
            result.addTraceInfo("Pattern did not match: " + txtVal);
            result.addTraceInfo("*** Architecture check failed. Unexpected pattern");
            result.addErrorInfo("Architecture check failed");
            result.addResultInfo(txtVal);
            result.setStatus(3);
            return false;
        }
        result.addTraceInfo("Architecure information couldn't be retrieved from the system");
        result.addErrorInfo("Architecture check failed");
        result.setStatus(2);
        return false;
    }

    @Override
    public boolean verifyPackage(String etoutput, String pkgname, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyPackage...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckPackage failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        boolean bMatched = Pattern.matches(".*package.*is not installed.*", txtVal);
        if (!(bMatched |= Pattern.matches(".*modinfo: could not find module .*", txtVal))) {
            ArrayList packageInfoList = new ArrayList();
            try {
                Vector packageStrs = null;
                packageStrs = GenericUtil.getAllStrByTags(txtVal, "PACKAGE");
                for (Object str : packageStrs) {
                    HashMap<String, String> packageInfo = new HashMap<String, String>();
                    packageInfo.put("NAME", GenericUtil.getValueByKey(str.toString(), "NAME"));
                    packageInfo.put("ARCH", GenericUtil.getValueByKey(str.toString(), "ARCH"));
                    packageInfo.put("VERSION", GenericUtil.getValueByKey(str.toString(), "VERSION"));
                    packageInfoList.add(packageInfo);
                }
            }
            catch (ParsingException p) {
                Trace.out((String)("Parsing Exception, while parsing: " + txtVal));
                result.addTraceInfo("*** Package check failed. Unexpected pattern: " + txtVal);
                result.setStatus(2);
                return false;
            }
            result.addResultInfo((Object)packageInfoList);
            result.setStatus(1);
            return true;
        }
        result.addTraceInfo("*** Package check failed. Unexpected pattern");
        result.addErrorInfo("CheckPackage failed for " + pkgname);
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyPackage(String etoutput, PackageConstraint pkgCon, Result result) {
        String pkgname = pkgCon.getKeyData();
        Trace.out((String)"==== Inside verifyPackage with constraint...");
        result.addTraceInfo("*** Inside verifyPackage with constraint...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            Trace.out((String)"==== verifyPackage: Exectask result failed");
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckPackage failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        boolean bMatched = Pattern.matches(".*package.*is not installed.*", txtVal = txtVal.trim());
        if (!bMatched) {
            try {
                Vector packageStrs = null;
                packageStrs = GenericUtil.getAllStrByTags(txtVal, "PACKAGE");
                for (Object str : packageStrs) {
                    txtVal = GenericUtil.getValueByKey(str.toString(), "NAME") + "-" + GenericUtil.getValueByKey(str.toString(), "VERSION");
                }
            }
            catch (ParsingException p) {
                Trace.out((String)("Parsing Exception, while parsing: " + txtVal));
                result.addTraceInfo("*** Package check failed. Unexpected pattern: " + txtVal);
                result.setStatus(2);
                return false;
            }
            if (pkgCon.getQualifier().equals("INRANGE")) {
                Trace.out((String)"==== checking qualifiers: INRANGE ");
                boolean failed = false;
                String cause = null;
                String avlVer = txtVal.substring(pkgname.length());
                Trace.out((String)("==== Available package version: " + avlVer));
                Vector rdVec = pkgCon.getRefData();
                String[] drt = rdVec.toArray(new String[rdVec.size()]);
                for (int i = 0; i < drt.length; ++i) {
                    String refVer;
                    String refPkg;
                    if (drt[i].startsWith("#CV_MAX)")) {
                        refPkg = drt[i].substring("#CV_MAX)".length());
                        refVer = refPkg.substring(pkgname.length());
                        Trace.out((String)("==== MAX drt for: " + refVer));
                        if (VerificationUtil.compareVersions(avlVer, refVer, "-") <= 0) continue;
                        cause = "Max limit " + refPkg;
                        failed = true;
                        continue;
                    }
                    if (drt[i].startsWith("#CV_MIN)")) {
                        refPkg = drt[i].substring("#CV_MIN)".length());
                        refVer = refPkg.substring(pkgname.length());
                        Trace.out((String)("==== MIN drt for: " + refVer));
                        if (VerificationUtil.compareVersions(avlVer, refVer, "-") >= 0) continue;
                        cause = "Min limit " + refPkg;
                        failed = true;
                        continue;
                    }
                    if (drt[i].startsWith("#CV_EX)")) {
                        refPkg = drt[i].substring("#CV_EX)".length());
                        refVer = refPkg.substring(pkgname.length());
                        Trace.out((String)("==== EX drt for: " + refVer));
                        if (VerificationUtil.compareVersions(avlVer, refVer, "-") != 0) continue;
                        cause = "Exclude " + refPkg;
                        failed = true;
                        continue;
                    }
                    if (!drt[i].startsWith("#CV_EXF)")) continue;
                    String refPkgLB = drt[i].substring("#CV_EXF)".length(), drt[i].indexOf("#CV_EXT)"));
                    String refVerLB = refPkgLB.substring(pkgname.length());
                    Trace.out((String)("==== EXF drt for: " + refVerLB));
                    String refPkgUB = drt[i].substring(drt[i].indexOf("#CV_EXT)") + "#CV_EXT)".length());
                    String refVerUB = refPkgUB.substring(pkgname.length());
                    Trace.out((String)("==== EXT drt for: " + refVerUB));
                    if (VerificationUtil.compareVersions(avlVer, refVerLB, "-") < 0 || VerificationUtil.compareVersions(avlVer, refVerUB, "-") > 0) continue;
                    cause = "Exclude range [" + refPkgLB + "," + refPkgUB + "]";
                    failed = true;
                }
                if (failed) {
                    result.addResultInfo(txtVal);
                    result.addTraceInfo("Package check failed due to " + cause);
                    result.addErrorInfo("CheckPackage failed for " + pkgname);
                    result.setStatus(3);
                    return false;
                }
                result.addResultInfo(txtVal);
                result.setStatus(1);
                return true;
            }
            if (pkgCon.getQualifier().equals("GTE")) {
                Trace.out((String)"==== checking qualifiers: GTE ");
                Vector rdVec = pkgCon.getRefData();
                String[] rdArr = rdVec.toArray(new String[rdVec.size()]);
                String rfPkgNm = rdArr[0];
                if (VerificationUtil.compareVersions(txtVal, rfPkgNm, "-") >= 0) {
                    result.addResultInfo(txtVal);
                    result.setStatus(1);
                    Trace.out((String)"==== VerifyPackage:GTE comparision passed ");
                    return true;
                }
                result.addResultInfo(txtVal);
                result.setStatus(3);
                Trace.out((String)"==== VerifyPackage:GTE comparision failed ");
                return true;
            }
            Trace.out((String)"==== checking qualifiers: EXIST, COMPARE ");
            result.addResultInfo(txtVal);
            result.setStatus(1);
            return true;
        }
        Trace.out((String)"==== Pattern did not match ");
        result.addTraceInfo("*** Package check failed. Unexpected pattern");
        result.addErrorInfo("CheckPackage failed for " + pkgname);
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyOSVersion(String etoutput, String osver, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyOSVersion...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckOSVersion failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        boolean bMatched = Pattern.matches(osver + ".*", txtVal);
        if (bMatched) {
            result.addResultInfo(txtVal);
            result.setStatus(1);
            return true;
        }
        result.addResultInfo(txtVal);
        result.addTraceInfo("*** OS version check failed. Unexpected pattern");
        result.addErrorInfo("CheckOSVersion failed");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyUserExistence(String etoutput, String username, Result result) {
        boolean bMatched;
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyUserExistence...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Check for user existence failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        boolean bl = bMatched = Pattern.matches("uid=.* gid=.*", txtVal = txtVal.trim()) && !Pattern.matches("id: invalid user name.*", txtVal);
        if (bMatched) {
            result.addResultInfo(username);
            String uid = txtVal.substring(txtVal.indexOf("=") + 1, txtVal.indexOf("("));
            result.addResultInfo(uid);
            Trace.out((String)("username='" + username + "' ; uid='" + uid + "'"));
            result.setStatus(1);
            return true;
        }
        result.addResultInfo(username);
        result.addTraceInfo("*** check for user existence failed. Unexpected pattern");
        result.addErrorInfo("User existence failed for " + username);
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyGroupExistence(String etoutput, String groupname, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyGroupExistence...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Error while checking group existence");
            result.setStatus(2);
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("1")) {
            result.addResultInfo(groupname);
            result.addTraceInfo("*** check for group existence failed.");
            result.addErrorInfo("Group '" + groupname + "' does not exist");
            result.setStatus(3);
            return false;
        }
        result.addResultInfo(groupname);
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        String gid = txtVal.substring(txtVal.indexOf("(") + 1, txtVal.indexOf(")"));
        result.addResultInfo(gid);
        result.setStatus(1);
        return true;
    }

    @Override
    public boolean verifyHostsFile(String etoutput, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyHostsFile...");
        Trace.out((String)("etoutput:<START>" + etoutput + "<END>"));
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Error while checking hosts file");
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationStatus(etoutput)) {
            result.addTraceInfo("hosts file check failed");
            result.addErrorInfo("Error while checking hosts file");
            result.setStatus(3);
            return false;
        }
        result.addTraceInfo("hosts file check passed");
        result.setStatus(1);
        return true;
    }

    @Override
    public boolean verifyUsrInGroup(String etoutput, String username, String groupname, int chkprim, Result result) {
        boolean bMatched;
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyUsrInGroup...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Check for user in group failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        int inxOfColon = txtVal.indexOf(":");
        if (inxOfColon != -1) {
            txtVal = txtVal.substring(inxOfColon + 1);
        }
        if (bMatched = Pattern.matches(".*No such user.*", txtVal = txtVal.trim())) {
            result.addResultInfo("");
            result.addResultInfo(groupname);
            result.addResultInfo("");
            result.addTraceInfo("*** check for user in group failed. Invalid user");
            result.setStatus(3);
            return false;
        }
        result.addResultInfo(username);
        String[] groups = VerificationUtil.getTokensAsArray(txtVal, " ");
        int index = -1;
        if (groups != null && groups.length >= 1) {
            for (int i = 0; i < groups.length; ++i) {
                if (!groups[i].equals(groupname)) continue;
                index = i;
                break;
            }
        }
        if (index != -1) {
            result.addResultInfo(groupname);
            result.addResultInfo(index == 0 ? "true" : "");
            boolean retval = true;
            if (chkprim == 1) {
                retval = index == 0;
            } else if (chkprim == 2) {
                retval = index != 0;
            }
            result.setStatus(retval ? 1 : 3);
            return retval;
        }
        result.addResultInfo("");
        result.addResultInfo("");
        result.addTraceInfo("Check for user in group failed.  User does not belong to this group.");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyMultUser(String etoutput, String uid, Result result) {
        String[] usrNameArr = null;
        String usrList = "";
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyMultUser...");
        Trace.out((String)("etoutput:<START>" + etoutput + "<END>"));
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Check for multiple users for UID with " + uid + " failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        if (txtVal != null && txtVal.length() != 0) {
            usrNameArr = (txtVal = txtVal.trim()).split(",");
            if (usrNameArr == null) {
                Trace.out((String)"usrNameArr is NULL");
            } else {
                Trace.out((String)("usrNameArr.length=" + usrNameArr.length));
            }
            if (txtVal.endsWith(",")) {
                usrList = txtVal.substring(0, txtVal.length() - 1);
                Trace.out((String)("usrList='" + usrList + "'"));
            }
        }
        if (usrNameArr == null || usrNameArr.length <= 1) {
            if (usrNameArr == null || usrNameArr.length == 0) {
                Trace.out((String)("No user found with uid='" + uid + "'"));
            } else {
                Trace.out((String)("Only one user ('" + usrList + "') found with uid='" + uid + "'"));
            }
            result.addTraceInfo("*** check for multiple users for UID " + uid + " passed");
            result.setStatus(1);
            return true;
        }
        void firstUsrName = usrNameArr[0];
        boolean multipleUsersFound = false;
        for (String uName : usrNameArr) {
            if (firstUsrName.trim().toLowerCase().compareTo(uName.trim().toLowerCase()) == 0) continue;
            multipleUsersFound = true;
            break;
        }
        result.addResultInfo(usrList);
        if (multipleUsersFound) {
            Trace.out((String)("Different user names ('" + usrList + "') found with uid = '" + uid + "'"));
            result.addTraceInfo("*** check for multiple users for UID " + uid + " failed");
            result.setStatus(3);
            return true;
        }
        Trace.out((String)("Multiple entries with same user name ('" + (String)firstUsrName + "') exists with uid = '" + uid + "'"));
        result.addTraceInfo("*** check for multiple users for UID " + uid + " passed");
        result.setStatus(1);
        return true;
    }

    @Override
    public boolean verifySwapSpace(String etoutput, long swapReqd, Result result) {
        return this.verifySwapSpace(etoutput, new StorageSize(swapReqd, StorageUnit.BYTE), result);
    }

    @Override
    public boolean verifySwapSpace(String etoutput, StorageSize swapReqd, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifySwapSpace...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckSwapSpace failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        boolean bMatched = Pattern.matches("SwapTotal: .* kB", txtVal = txtVal.trim());
        if (bMatched) {
            int start = txtVal.indexOf(": ") + 2;
            int end = txtVal.indexOf("kB") - 1;
            String val = txtVal.substring(start, end);
            val = val.trim();
            double avlSwap = 0.0;
            StorageSize avlSwapSS = new StorageSize(0.0, StorageUnit.BYTE);
            try {
                avlSwap = VerificationUtil.parseStringToNumber(val);
                avlSwapSS = new StorageSize(avlSwap, StorageUnit.KBYTE);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            if (avlSwapSS.compareTo(swapReqd) >= 0) {
                result.addResultInfo(avlSwapSS);
                result.setStatus(1);
                return true;
            }
            result.addTraceInfo("*** Swap Space check failed. Reqd: " + swapReqd + ", avail: " + avlSwap);
            result.addErrorInfo("CheckSwapSpace failed");
            result.addResultInfo(avlSwapSS);
            result.setStatus(3);
            return false;
        }
        result.addTraceInfo("*** Swap Space check failed. Unexpected pattern");
        result.addErrorInfo("CheckSwapSpace failed");
        result.setStatus(2);
        return false;
    }

    @Override
    public boolean verifyKernelVersion(String etoutput, String krnver, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyKernelVersion...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckKernelVersion failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        if (VerificationUtil.compareVersions(txtVal = txtVal.trim(), krnver, "-") >= 0) {
            result.addResultInfo(txtVal);
            result.setStatus(1);
            return true;
        }
        result.addResultInfo(txtVal);
        result.addTraceInfo("*** Kernel version check failed.");
        result.addErrorInfo("CheckKernelVersion failed");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyKerParam(String etoutput, String param, long reqval, Result result) {
        boolean bMatched;
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyKerParam...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Check for kernel parameter failed");
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationResult(etoutput).equals("0")) {
            result.addTraceInfo("Kernel Parameter retrieval failed for parameter:" + param);
            result.addErrorInfo("Check for kernel parameter '" + param + "' failed");
            result.setStatus(2);
            return false;
        }
        String txtCurVal = VerificationUtil.fetchTextByTags(etoutput, "<CV_CUR>", "</CV_CUR>");
        String txtCfgVal = VerificationUtil.fetchTextByTags(etoutput, "<CV_CFG>", "</CV_CFG>");
        String pageSizeVal = VerificationUtil.fetchTextByTags(etoutput, "<PAGE_SIZE>", "</PAGE_SIZE>");
        Trace.out((String)("pageSizeVal=" + pageSizeVal));
        txtCurVal = txtCurVal != null ? txtCurVal.trim() : "";
        txtCfgVal = txtCfgVal != null ? txtCfgVal.trim() : "";
        String string = pageSizeVal = pageSizeVal != null ? pageSizeVal.trim() : "";
        if (txtCurVal.length() <= 0 || txtCfgVal.length() <= 0) {
            result.addTraceInfo("Exectask result failed");
            result.addTraceInfo("Could not retrieved value for " + param);
            result.addErrorInfo("Check for kernel parameter failed");
            result.setStatus(2);
            return false;
        }
        boolean bl = bMatched = Pattern.matches(".* = .*", txtCurVal) && Pattern.matches(".* = .*", txtCfgVal);
        if (bMatched) {
            int start = txtCurVal.indexOf("= ") + 2;
            String tCurVal = txtCurVal.substring(start);
            tCurVal = tCurVal.trim();
            start = txtCfgVal.indexOf("= ") + 2;
            String tCfgVal = txtCfgVal.substring(start);
            tCfgVal = tCfgVal.trim();
            int wordInx = 0;
            if (param.equals("semmsl")) {
                wordInx = 0;
            } else if (param.equals("semmns")) {
                wordInx = 1;
            } else if (param.equals("semopm")) {
                wordInx = 2;
            } else if (param.equals("semmni")) {
                wordInx = 3;
            }
            String[] wordArr = tCurVal.split("\\s+");
            if (wordArr == null || wordArr.length < wordInx + 1) {
                result.addTraceInfo("Exectask result failed");
                result.addTraceInfo("Could not retrieved value for " + param);
                result.addErrorInfo("Check for kernel parameter failed");
                result.setStatus(2);
                return false;
            }
            tCurVal = wordArr[wordInx];
            tCfgVal = tCfgVal.split("\\s+")[wordInx];
            double lCurVal = 0.0;
            double lCfgVal = 0.0;
            try {
                lCurVal = VerificationUtil.parseStringToNumber(tCurVal);
                lCfgVal = VerificationUtil.parseStringToNumber(tCfgVal);
            }
            catch (NumberFormatException e) {
                result.addResultInfo(param);
                result.addResultInfo(tCurVal);
                result.addResultInfo(tCfgVal);
                result.addTraceInfo("Invalid number format for kernel parameter " + param);
                result.addErrorInfo("Kernel parameter check failed for " + param);
                result.setStatus(2);
                return false;
            }
            if (lCurVal >= (double)reqval && lCfgVal >= (double)reqval) {
                if (VerificationUtil.isStringGood(pageSizeVal)) {
                    result.addResultInfo(pageSizeVal);
                }
                result.addResultInfo(param);
                result.addResultInfo(tCurVal);
                result.addResultInfo(tCfgVal);
                result.addTraceInfo("exectask val: " + tCurVal);
                result.setStatus(1);
                return true;
            }
            if (VerificationUtil.isStringGood(pageSizeVal)) {
                result.addResultInfo(pageSizeVal);
            }
            result.addResultInfo(param);
            result.addResultInfo(tCurVal);
            result.addResultInfo(tCfgVal);
            result.addTraceInfo("Insufficient value for kernel param " + param);
            result.addErrorInfo("Kernel param verificaiton failed for " + param);
            result.setStatus(3);
            return false;
        }
        result.addTraceInfo("*** Kernel Parameter check failed. Unexpected pattern");
        result.addErrorInfo("CheckKerenelParam failed");
        result.setStatus(2);
        return false;
    }

    @Override
    public boolean verifySysParam(String etoutput, String param, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifySysParam...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Error while checking system parameter");
            result.setStatus(2);
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("1")) {
            result.addTraceInfo("*** param not defined.");
            result.addErrorInfo("Param '" + param + "' does not exist");
            result.setStatus(3);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        result.addResultInfo(txtVal);
        result.setStatus(1);
        return true;
    }

    @Override
    public boolean verifyOSPatch(String etoutput, String patch, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyOSPatch...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Error while checking OS patch");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        boolean bMatched = Pattern.matches(".*package.*is not installed.*", txtVal = txtVal.trim());
        if (!bMatched) {
            result.addResultInfo(txtVal);
            result.setStatus(1);
            return true;
        }
        result.addTraceInfo("*** Patch has not been applied.");
        result.addErrorInfo("OS patch '" + patch + "' has not been applied.");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyDaemonLiveliness(String etoutput, String dmnname, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyDaemonLiveliness...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckDaemonLiveliness failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        String[] proclist = VerificationUtil.getTokensAsArray(txtVal, System.getProperty("line.separator"));
        boolean bMatched = false;
        for (int i = 0; i < proclist.length; ++i) {
            if (!proclist[i].equalsIgnoreCase(dmnname)) continue;
            bMatched = true;
            break;
        }
        if (bMatched) {
            Trace.out((String)("Daemon liveliness check passed for " + dmnname));
            result.addResultInfo(dmnname);
            result.setStatus(1);
            return true;
        }
        Trace.out((String)("Daemon liveliness check failed for " + dmnname));
        result.addTraceInfo("*** Daemon liveliness check failed.");
        result.addErrorInfo("CheckDaemonLiveliness failed for " + dmnname);
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyFileExists(String etoutput, String pathName, Result result) {
        result.addTraceInfo("==== Inside sExecutionAnalyzer.verifyFileExists...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("verifyFileExists failed");
            result.setStatus(2);
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("0")) {
            String fileSize = VerificationUtil.fetchVerificationValue(etoutput);
            if (fileSize != null) {
                result.addResultInfo(fileSize);
            }
            result.addTraceInfo("==== File existence check was successful. ");
            result.setStatus(1);
            return true;
        }
        result.addTraceInfo("==== File existence check failed. ");
        result.addErrorInfo("verifyFileExists failed");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean pickRunExeOutput(String etoutput, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.pickRunExeOutput...");
        Trace.out((String)("==== Exectask output: " + etoutput));
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("RunExeCommand failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        String[] outlist = VerificationUtil.getTokensAsArray(txtVal, System.getProperty("line.separator"));
        result.addResultInfo(outlist);
        result.addResultInfo(etoutput);
        result.setStatus(1);
        return true;
    }

    private String filterValueForTimeZone(String Output, String tagPattern) {
        String delim = "#";
        String[] theArray = VerificationUtil.string2strArr(Output, delim);
        String retstr = "";
        if (theArray != null && theArray.length > 2) {
            int theIndex = 0;
            for (int j = 0; j < theArray.length; ++j) {
                if (j < 2 || !theArray[j].contains(tagPattern) || !theArray[j - 2].contains(tagPattern)) continue;
                theIndex = j - 1;
            }
            retstr = theArray[theIndex];
        }
        return retstr;
    }

    @Override
    public List<String> parseGetGroupsOutput(String etoutput) {
        ArrayList<String> groupList = new ArrayList<String>();
        Trace.out((int)5, (String)"*** Inside sExecutionAnalyzer.parseGetGroupsOutput...");
        Trace.out((String)("==== Exectask output: " + etoutput));
        VerificationLogData.log("Exectask output is: " + etoutput);
        if (!VerificationUtil.isStringGood(etoutput) || !VerificationUtil.fetchExecResult(etoutput)) {
            VerificationLogData.log("Exectask result failed");
            Trace.out((int)5, (String)"Exectask result failed");
            Trace.out((int)5, (String)"exectask -getgroups command failed");
        } else {
            String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
            int inxOfColon = txtVal.indexOf(":");
            if (inxOfColon != -1) {
                txtVal = txtVal.substring(inxOfColon + 1);
            }
            if (VerificationUtil.isStringGood(txtVal = txtVal.trim())) {
                groupList.addAll(Arrays.asList(txtVal.trim().split(" ")));
            }
        }
        return groupList;
    }

    @Override
    public boolean parseRunFixupOutput(String etoutput, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.parseRunFixupOutput...");
        Trace.out((String)("==== Exectask output: " + etoutput));
        VerificationLogData.log("Exectask output is -" + etoutput);
        String output = null;
        if (etoutput.contains("<CV_")) {
            output = etoutput.substring(etoutput.indexOf("<CV_"));
        }
        Trace.out((String)("==== Truncated Exectask output: " + output));
        VerificationLogData.log("Truncated Exectask output is -" + output);
        if (!VerificationUtil.isStringGood(output) || !VerificationUtil.fetchExecResult(output)) {
            VerificationLogData.log("Exectask result failed");
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("RunFixupCommand failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(output);
        txtVal = txtVal.trim();
        Trace.out((String)("The output file path retrieved is " + txtVal));
        result.addResultInfo(txtVal);
        result.addResultInfo(output);
        result.setStatus(1);
        return true;
    }
}

